"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppImageUpdater = void 0;

function _bluebirdLst() {
  const data = require("bluebird-lst");

  _bluebirdLst = function () {
    return data;
  };

  return data;
}

function _builderUtilRuntime() {
  const data = require("builder-util-runtime");

  _builderUtilRuntime = function () {
    return data;
  };

  return data;
}

function _child_process() {
  const data = require("child_process");

  _child_process = function () {
    return data;
  };

  return data;
}

function _fsExtraP() {
  const data = require("fs-extra-p");

  _fsExtraP = function () {
    return data;
  };

  return data;
}

var path = _interopRequireWildcard(require("path"));

require("source-map-support/register");

function _BaseUpdater() {
  const data = require("./BaseUpdater");

  _BaseUpdater = function () {
    return data;
  };

  return data;
}

function _FileWithEmbeddedBlockMapDifferentialDownloader() {
  const data = require("./differentialDownloader/FileWithEmbeddedBlockMapDifferentialDownloader");

  _FileWithEmbeddedBlockMapDifferentialDownloader = function () {
    return data;
  };

  return data;
}

function _Provider() {
  const data = require("./providers/Provider");

  _Provider = function () {
    return data;
  };

  return data;
}

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

class AppImageUpdater extends _BaseUpdater().BaseUpdater {
  constructor(options, app) {
    super(options, app);
  }

  isUpdaterActive() {
    if (process.env.APPIMAGE == null) {
      if (process.env.SNAP == null) {
        this._logger.warn("APPIMAGE env is not defined, current application is not an AppImage");
      } else {
        this._logger.info("SNAP env is defined, updater is disabled");
      }

      return false;
    }

    return super.isUpdaterActive();
  }
  /*** @private */


  doDownloadUpdate(downloadUpdateOptions) {
    var _this = this;

    const provider = downloadUpdateOptions.updateInfoAndProvider.provider;
    const fileInfo = (0, _Provider().findFile)(provider.resolveFiles(downloadUpdateOptions.updateInfoAndProvider.info), "AppImage");
    return this.executeDownload({
      fileExtension: "AppImage",
      fileInfo,
      downloadUpdateOptions,
      task: function () {
        var _ref = (0, _bluebirdLst().coroutine)(function* (updateFile, downloadOptions) {
          const oldFile = process.env.APPIMAGE;

          if (oldFile == null) {
            throw (0, _builderUtilRuntime().newError)("APPIMAGE env is not defined", "ERR_UPDATER_OLD_FILE_NOT_FOUND");
          }

          let isDownloadFull = false;

          try {
            yield new (_FileWithEmbeddedBlockMapDifferentialDownloader().FileWithEmbeddedBlockMapDifferentialDownloader)(fileInfo.info, _this.httpExecutor, {
              newUrl: fileInfo.url,
              oldFile,
              logger: _this._logger,
              newFile: updateFile,
              isUseMultipleRangeRequest: provider.isUseMultipleRangeRequest,
              requestHeaders: downloadUpdateOptions.requestHeaders
            }).download();
          } catch (e) {
            _this._logger.error(`Cannot download differentially, fallback to full download: ${e.stack || e}`); // during test (developer machine mac) we must throw error


            isDownloadFull = process.platform === "linux";
          }

          if (isDownloadFull) {
            yield _this.httpExecutor.download(fileInfo.url, updateFile, downloadOptions);
          }

          yield (0, _fsExtraP().chmod)(updateFile, 0o755);
        });

        return function task(_x, _x2) {
          return _ref.apply(this, arguments);
        };
      }()
    });
  }

  doInstall(options) {
    const appImageFile = process.env.APPIMAGE;

    if (appImageFile == null) {
      throw (0, _builderUtilRuntime().newError)("APPIMAGE env is not defined", "ERR_UPDATER_OLD_FILE_NOT_FOUND");
    } // https://stackoverflow.com/a/1712051/1910191


    (0, _fsExtraP().unlinkSync)(appImageFile);
    let destination;
    const existingBaseName = path.basename(appImageFile); // https://github.com/electron-userland/electron-builder/issues/2964
    // if no version in existing file name, it means that user wants to preserve current custom name

    if (path.basename(options.installerPath) === existingBaseName || !/\d+\.\d+\.\d+/.test(existingBaseName)) {
      // no version in the file name, overwrite existing
      destination = appImageFile;
    } else {
      destination = path.join(path.dirname(appImageFile), path.basename(options.installerPath));
    }

    (0, _child_process().execFileSync)("mv", ["-f", options.installerPath, destination]);
    const env = Object.assign({}, process.env, {
      APPIMAGE_SILENT_INSTALL: "true"
    });

    if (options.isForceRunAfter) {
      (0, _child_process().spawn)(destination, [], {
        detached: true,
        stdio: "ignore",
        env
      }).unref();
    } else {
      env.APPIMAGE_EXIT_AFTER_INSTALL = "true";
      (0, _child_process().execFileSync)(destination, [], {
        env
      });
    }

    return true;
  }

} exports.AppImageUpdater = AppImageUpdater;
// __ts-babel@6.0.4
//# sourceMappingURL=AppImageUpdater.js.map